%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  FileName:            mfTxTrchCoder.m
%  Description:         ŵ
%  Reference:           3GPP TS 25.212, 4.2.3 Channel coding
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  Parameter List:       
%       Output Parameter
%           out_data	ŵ 
%       Input Parameter
%           input_data	
%           input_num	ݱ
%           coder_type  ͣ0ʾ룬1ʾ1/2룬2ʾ1/3
%                       3ʾTurbo              
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  History
%    1. Date:           2017-12-1
%       Author:         david.lee
%       Version:        1.0 
%       Modification:   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [out_data] = mfTxTrchCoder(input_data, input_num, coder_type)

%% ʵ
switch coder_type
	case 0
        out_data = zeros(1, input_num);     %#ok
        out_data = input_data;
    % 1/2
    case 1
        %βأݺ80
        temp_data = zeros(1, input_num+8);
        temp_data(1,1:input_num) = input_data;
        input_num = input_num+8;
        %
        out_data = zeros(1, input_num*2);     %#ok
        CodeGenerator = [561, 753];
        K = 9;
        trellis = poly2trellis(K, CodeGenerator);
        out_data = convenc(temp_data, trellis);  
    % 1/3
    case 2
        %βأݺ80
        temp_data = zeros(1, input_num+8);
        temp_data(1,1:input_num) = input_data;
        input_num = input_num+8;
        %
        out_data = zeros(1, input_num*3);     %#ok
        CodeGenerator = [557, 663, 711];
        K = 9;
        trellis = poly2trellis(K, CodeGenerator);
        out_data = convenc(temp_data, trellis);  
    case 3
        fprintf('error:mfTxTrchCoderĲcoder_type=3ݲ֧\n');
    otherwise
        fprintf('error:mfTxTrchCoderĲcoder_type\n');
end    

end